<?php

class UserAdministratorIdentity extends CUserIdentity
{
	const ERROR_TEACHER_EMPTY_CLASS = 200;

	private $id;

	public function authenticate()
	{
		$userModel = Admin::model()->findByAttributes(array('login'=>$this->username));
		$this->errorCode = self::ERROR_USERNAME_INVALID;

		if($userModel === null)
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		else if(hash('sha1', $this->password) !== $userModel->haslo)
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		//else if ($userModel->rodzaj == 1 && (int)$userModel->iloscKlas == 0)
		//	$this->errorCode = self::ERROR_TEACHER_EMPTY_CLASS;
		else
		{
			$this->errorCode = self::ERROR_NONE;

			if($userModel->rodzaj==1)
			{
				$this->setState('type', 1);
				$this->setState('role','teacher');
			}
			elseif($userModel->rodzaj==0)
			{
				$this->setState('type', 0);
				$this->setState('role','admin');
			}
			elseif($userModel->rodzaj==3)
			{
				$this->setState('type', 3);
				$this->setState('role','schoolAdmin');
				$this->setState('schoolId',$userModel->idSzkoly);
				$this->setState('classes',$this->getClassesBySchoolId($userModel->idSzkoly));
				$this->setState('companies',$this->getCompaniesByClassesIds($this->getState('classes')));
				$this->setState('tenders',$this->getTendersByClassesIds($this->getState('classes')));
			}
			$this->id = $userModel->id;
			$this->username = $userModel->login;
			$this->setState('name',$userModel->imie);
			$this->setState('surname',$userModel->nazwisko);
		}

		return $this->errorCode == self::ERROR_NONE;
	}

	public function getId()
	{
		return $this->id;
	}
	
	/**
	 * Zwraca tablice identyfikatorow klas nalezacych do danej szkoly.
	 * Funkcja uzywana przy filtrowaniu widokow dla administratora szkoly.
	 * @param int|string $schoolId ID szkoly
	 * @return array tablica z identyfikatorami szkol
	 */
	private function getClassesBySchoolId($schoolId)
	{
		return Yii::app()->db->createCommand('select k."id" from "Klasa" k where k."idSzkoly" = :schoolId and k."czyTestowa" != 1')->queryColumn(array(':schoolId'=>$schoolId));
	}

	/**
	 * Zwraca tablice identyfikatorow firm nalezacych do danej szkoly.
	 * Funkcja uzywana przy filtrowaniu widokow dla administratora szkoly.
	 * @param array $classesIds identyfikatory klas nalezacych do danej firmy.
	 * Parametr <b>$classesIds</b> pochodzi z funkcji @see getClassesBySchoolId
	 * @return array tablica z identyfikatorami firm
	 */
	private function getCompaniesByClassesIds($classesIds)
	{
		if(count($classesIds))
			return Yii::app()->db->createCommand('select f.* from "Firma" f where f."idKlasy" in ('.implode(',', $classesIds).')')->queryColumn();
		
		return array();
	}
	
	/**
	 * Zwraca tablice identyfikatorow z tabeli PrzetargGrupa dla danej szkoly.
	 * Funkcja uzywana przy pobraniu zgloszonych przetargow w panelu admina szkoly.
	 * @param array $classesIds identyfikatory klas nalezacych do danej firmy.
	 * Parametr <b>$classesIds</b> pochodzi z funkcji @see getClassesBySchoolId
	 * @return array tablica z identyfikatorami z tabeli PrzetarGrupa
	 */
	private function getTendersByClassesIds($classesIds)
	{
		if(count($classesIds))
			return Yii::app()->db->createCommand('
				select t."id" from "PrzetargGrupa" t 
				left join "Przetarg" p on p."id" = t."idPrzetargu"
				where p."idKlasy" in ('.implode(',', $classesIds).')')->queryColumn();
		
		return array();
	}
}
